<?php

namespace App\Http\Controllers;

use App\Models\Articulo;
use App\Models\Cuenta;
use App\Models\Empresa;
use Illuminate\Http\Request;

class ArticuloController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $articulos=Articulo::select('a.idarticulo',
        'a.nombre',
        'a.idcuenta',
        'a.nombre',
        'a.nota',
        'c.nombre as cuenta',
        'a.estado')
        ->from('articulo as a')
        ->join('cuenta as c','a.idcuenta','=','c.idcuenta')
        ->where(function ($q) {
            $q->where('a.nombre','like','%'.trim(request()->texto).'%')->orWhere('c.nombre','like','%'.trim(request()->texto).'%')->orWhere('a.nota','like','%'.trim(request()->texto).'%')->orWhere('a.estado','like','%'.trim(request()->texto).'%');
        })
        ->where('a.idempresa', auth()->user()->idempresa) 
        // ->where('a.idarticulo','like','%'.$texto.'%')
        // ->orWhere('a.nombre','like','%'.$texto.'%')
        // ->orWhere('c.nombre','like','%'.$texto.'%')
        // ->orWhere('a.estado',$texto)
        ->paginate(5)->withQueryString();
        /*-------------------------------------------------------------*/
         return view('articulo.index',compact('articulos','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cuentas=Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        return view('articulo.create',compact('cuentas'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Articulo::Where('nombre', request()->nombre)
                            ->where('idempresa', auth()->user()->idempresa)
                            ->first();
            if (is_null($duplicado)) {
                $campos=[
                    'nombre'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo :attribute es requerido'
                ];

                $this->validate($request,$campos,$mensaje);
                $datosArticulo=request()->except('_token');
                Articulo::insert($datosArticulo);
                return redirect('articulo')->with('mensaje','Datos del Artículo, guardados correctamente...');
        }else{                
            return redirect()->back()->with('mensaje','El Artículo ya existe...!'); 
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $articulo =Articulo::findOrFail($id);
        $cuentas=Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        return view('articulo.edit',compact('articulo','cuentas'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Articulo::Where([
            ['nombre', request()->nombre],
            ['idempresa', auth()->user()->idempresa],
            ['idarticulo', '!=', $id]
        ])
        ->first();
        if (is_null($duplicado)) {
            $campos=[
                'nombre'=>'required|string|max:45',
            ];

            $mensaje = [
                'required'=> 'El campo :attribute es requerido'
            ];

            $this->validate($request,$campos,$mensaje);

            $datosArticulo=request()->except(['_token','_method']);
            Articulo::where('idarticulo','=',$id)->update($datosArticulo);
            return redirect('articulo')->with('mensaje','Datos del Artículo, editados correctamente...');
        }else{
            return redirect()->back()->with('mensaje','El Artículo ya existe...!'); 
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
