<?php

namespace App\Http\Controllers;

use App\Models\Asiento;
use App\Models\Cuenta;
use App\Models\Deposito;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AsientoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $empresas = Empresa::all();
        $sucursales = Sucursal::all();
        $asientos=Asiento::where('idasiento','like','%'.$texto.'%')
        ->orwhere('fecha','like','%'.$texto.'%')
        ->orwhere('nro_asiento','like','%'.$texto.'%')
        ->paginate(5)->withQueryString();
        return view('asiento.index',compact('asientos','texto','sucursales','empresas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $empresas = Empresa::all();
        $sucursales = Sucursal::all();
        $cuentas = Cuenta::all();
        $date = DB::select('select date(now()) as fecha');
        return view('asiento.create', compact('empresas', 'sucursales','cuentas','date'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Asiento::where('asiento_nro', request()->asiento_nro)
        ->first();
            if (is_null($duplicado)) {
                $campos=[
                    'asiento_nro'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo "Asiento" es requerido'
                ];

                $this->validate($request,$campos,$mensaje);

                $datosAsiento=request()->except('_token');
                Asiento::insert($datosAsiento);
                $datos['asientos'] = Asiento::paginate(5);
                // return view('ciudad.index',$datos);
                return redirect('asiento')->with('mensaje','Asiento guardado...');
            }else{                
                return redirect()->back()->with('mensaje','EL Nº de Asiento ya existe...!');
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
