<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Ciudad;
use Barryvdh\DomPDF\Facade\Pdf;

class CiudadController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /** Create a new controller instance.
     *  @return void
     **/

     public function __construct()
    {
        $this->middleware('auth');
    }

    
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $ciudades=Ciudad::where('idciudad','like','%'.$texto.'%')
        ->orWhere('nombre','like','%'.$texto.'%')
        ->orWhere('estado',$texto)
        ->paginate(5)->withQueryString();
        /*-------------------------------------------------------------*/
         return view('ciudad.index',compact('ciudades','texto'));
        
    }

    /*public function pdf(Request $request)
    {
        $ciudades=Ciudad::where('estado','ACTIVO')->paginate();
        $pdf=Pdf::loadView('ciudad.pdf',['ciudades'=>$ciudades]);
        /*-------------------------------------------------------------*/
        /* return view('ciudad.pdf',compact('ciudades')); */
       /* return $pdf->stream();
    }*/

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('ciudad.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Ciudad::where('nombre', request()->nombre)
        ->first();
            if (is_null($duplicado)) {
                $campos=[
                    'nombre'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo "Nombre" es requerido'
                ];

                $this->validate($request,$campos,$mensaje);

                $datosCiudad=request()->except('_token');
                Ciudad::insert($datosCiudad);
                return redirect('ciudad')->with('mensaje','Datos de la Ciudad, guardados correctamente...');
            }else{                
                return redirect()->back()->with('mensaje','La ciudad ya existe...!');
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ciudad =Ciudad::findOrFail($id);
        return view('ciudad.edit',compact('ciudad'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Ciudad::Where([
            ['nombre', request()->nombre],
            ['idciudad', '!=', $id]])
            ->first();        
            if (is_null($duplicado)) {
                $campos=[
                    'nombre'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo "Nombre" es requerido'
                ];

                $this->validate($request,$campos,$mensaje);
                $datosCiudad=request()->except(['_token','_method']);
                Ciudad::where('idciudad','=',$id)->update($datosCiudad);
                return redirect('ciudad')->with('mensaje','Datos de la Ciudad, editados correctamente...');
            }else{
                return redirect()->back()->with('mensaje','La ciudad ya existe...!'); 
            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Ciudad::destroy($id);
        // return redirect('ciudad')->with('mensaje','Ciudad borrada...');
    }
}
