<?php

namespace App\Http\Controllers;

use App\Models\Empresa;
use Illuminate\Http\Request;

class EmpresaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $empresas=Empresa::select('e.idempresa',
        'e.nombre',
        'e.ruc',
        'e.direccion',
        'e.idciudad',
        'c.nombre as ciudad',
        'e.telefono',
        'c.estado')
        ->from('empresa as e')
        ->join('ciudad as c','e.idciudad','=','c.idciudad')
        ->where(function ($q) {
             $q->where('e.ruc','like','%'.trim(request()->texto).'%')
             ->orWhere('e.nombre','like','%'.trim(request()->texto).'%')
             ->orWhere('e.telefono','like','%'.trim(request()->texto).'%')
             ->orWhere('e.estado','like','%'.trim(request()->texto).'%')
             ->orWhere('e.direccion','like','%'.trim(request()->texto).'%')
             ->orWhere('c.nombre','like','%'.trim(request()->texto).'%')
             ->orWhere('e.estado','like','%'.trim(request()->texto).'%');
        })
        ->paginate(8)->withQueryString();
        /*------------------------------------------------------- */
        // $empresas=Empresa::where('idempresa','like','%'.$texto.'%')
        // ->orWhere('ruc','like','%'.$texto.'%')
        // ->orWhere('nombre','like','%'.$texto.'%')
        // ->orWhere('telefono','like','%'.$texto.'%')
        // ->orWhere('estado',$texto)
        // ->paginate(5)->withQueryString();
        /*-------------------------------------------------------------*/
        return view('empresa.index',compact('empresas','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('empresa.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Empresa::where('nombre', request()->nombre)
        ->first();
            if (is_null($duplicado)) {
                $campos=[
                    'nombre'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo "Nombre" es requerido'
                ];

                $this->validate($request,$campos,$mensaje);

                $datosEmpresa=request()->except('_token');
                Empresa::insert($datosEmpresa);
                return redirect('empresa')->with('mensaje','Datos de la Empresa, guardados correctamente...');
            }else{                
                return redirect()->back()->with('mensaje','La Empresa ya existe...!');
            }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $empresa =Empresa::findOrFail($id);
        return view('empresa.edit',compact('empresa'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Empresa::Where([
            ['nombre', request()->nombre],
            ['idempresa', '!=', $id]
        ])
        ->first();        
            if (is_null($duplicado)) {
                $campos=[
                    'nombre'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo "Nombre" es requerido'
                ];

                $this->validate($request,$campos,$mensaje);

                $datosEmpresa=request()->except(['_token','_method']);
                Empresa::where('idempresa','=',$id)->update($datosEmpresa);
                return redirect('empresa')->with('mensaje','Datos de la Empresa, editados correctamente...');
            }else{
                return redirect()->back()->with('mensaje','La empresa ya existe...!'); 
            }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
