<?php

namespace App\Http\Controllers;

use App\Models\Ciudad;
use App\Models\Cuenta;
use App\Models\Empresa;
use App\Models\Proveedor;
use Illuminate\Http\Request;

class ProveedorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /** Create a new controller instance.
     *  @return void
     **/
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $proveedores=Proveedor::select('p.idproveedor',
        'p.idempresa',
        'e.nombre as empresa',
        'p.idcuenta',
        'c.nombre as cuenta',
        'p.ruc',
        'p.denominacion',
        'p.direccion',
        'p.telefono',
        'p.estado')
        ->from('proveedor as p')
        ->join('empresa as e','p.idempresa','=','e.idempresa')
        ->join('cuenta as c','p.idcuenta','=','c.idcuenta')
        ->where(function ($q) {
            $q->where('p.denominacion','like','%'.trim(request()->texto).'%')
            ->orWhere('p.idproveedor','like','%'.trim(request()->texto).'%')
            ->orWhere('p.ruc','like','%'.trim(request()->texto).'%')
            ->orWhere('c.nombre','like','%'.trim(request()->texto).'%')
            ->orWhere('p.direccion','like','%'.trim(request()->texto).'%')
            ->orWhere('p.telefono','like','%'.trim(request()->texto).'%')
            ->orWhere('p.estado','like','%'.trim(request()->texto).'%');
        })
        ->where('p.idempresa', auth()->user()->idempresa) 
        ->paginate(5)->withQueryString();
        /*---------------------------------------------------------- */
        return view('proveedor.index',compact('proveedores','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cuentas=Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        return view('proveedor.create',compact('cuentas'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Proveedor::where('ruc', request()->ruc)
                              ->where('idempresa', auth()->user()->idempresa)    
                              ->first();
        if (is_null($duplicado)) {
            $campos=[
                'denominacion'=>'required|string|max:45',
                'ruc'=>'required|string|max:45',
                'telefono'=>'required|string|max:45',
            ];

            $mensaje = [
                'required'=> 'El campo :attribute  es requerido'
            ];

            $this->validate($request,$campos,$mensaje);
            $datosProveedor=request()->except('_token');
            Proveedor::insert($datosProveedor);
            $datos['proveedores'] = Proveedor::paginate(5);
            return redirect('proveedor')->with('mensaje','Datos del Proveedor, guardados correctamente...');
        }else{                
            return redirect()->back()->with('mensaje','El Nº de RUC ya existe...!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $proveedor =Proveedor::findOrFail($id);
        $cuentas= Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        return view('proveedor.edit',compact('proveedor','cuentas'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Proveedor::where('ruc', request()->ruc)
                              ->where('idempresa', auth()->user()->idempresa)    
                              ->where('idproveedor', '!=', $id)            
                              ->first();

        // $duplicado = Proveedor::where(function ($q) {
        //     $q->where('denominacion', request()->denominacion)->orWhere('ruc', request()->ruc);
        // })            
        // ->where('idproveedor', '!=', $id)            
        // ->first();
        //dd($duplicado);               
        if (is_null($duplicado)) {
            $campos=[
                'denominacion'=>'required|string|max:45',
                'ruc'=>'required|string|max:45',
            ];

            $mensaje = [
                'required'=> 'El campo :attribute es requerido'
            ];

            $this->validate($request,$campos,$mensaje);

            $datosProveedor=request()->except(['_token','_method']);
            Proveedor::where('idproveedor','=',$id)->update($datosProveedor);
            return redirect('proveedor')->with('mensaje','Datos del Proveedor, editados correctamente...');
        }else{                
            return redirect()->back()->with('mensaje','El Nº de RUC ya existe...!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Proveedor::destroy($id);
        return redirect('proveedor')->with('mensaje','Proveedor borrado...');
    }
}
