<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Helpers\ModelMPK;
//use Illuminate\Database\Query\Builder;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Laracasts\Flash\Flash;

use App\Models\Rol;
use App\Models\Pagina;
use App\Models\Permiso;


class RolController extends Controller
{
    /** Create a new controller instance.
     *  @return void
     **/
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /** Display a listing of the resource.
    * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $rol=Rol::where('idrol','like','%'.$texto.'%')
        ->orwhere('nombrerol','like','%'.$texto.'%')
        ->orwhere('estado',$texto)
        ->paginate(5)->withQueryString();
        return view('rol.index',compact('rol','texto'));
    }

    /** Show the form for creating a new resource.
     *  @return \Illuminate\Http\Response
     **/
    public function create()
    {
        return view('rol.create');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $campos=[
        //     'nombre'=>'required|string|max:45',
        // ];

        // $mensaje = [
        //     'required'=> 'El campo "Nombre" es requerido'
        // ];

        // $this->validate($request,$campos,$mensaje);
        //dd(request()->nombrerol,request()->estadorol);

        if (request()->updatepermisos) {
           // dd('entro por store!');
            // dd(request()->idrol);
            //dd(request()->permi);
            //dd(request()->permiactual);
            try {
                if (!is_null(request()->permi)) {
                    foreach (request()->permi as $value) {
                        if (isset($value['idpagina'])) {
                            $permisos = [
                                'idrol' => request()->idrol,
                                "idpagina" => $value['idpagina'],
                                'estado' => $value['estado'],                        
                                ];

                            $grabado = Permiso::updateOrCreate([
                                'idrol' => request()->idrol,
                                'idpagina' => $value['idpagina']], $permisos); 
                        }
                    }
                }
                if (!is_null(request()->permiactual)) {
                    foreach (request()->permiactual as $permivalue) {
                        $permisos = [
                            'idrol' => request()->idrol,
                            'idpagina' => $permivalue['idpagina'],
                            'estado' => $permivalue['estado'],                        
                            ];
                        $grabado=Permiso::where('idpermiso','=',$permivalue['idpermiso'])->update($permisos);
                    }
                }

                return redirect('rol')->with('mensaje','Permisos actualizados!');
            } catch (\Exception $e) {
                log::info($e);
                #throw $e;
                // Flash::error('No se pudo realizar la asignación');
                // Flash::error($e->getMessage());
                // DB::rollback();
                return redirect('rol')->with('mensaje',$e);
            }    
                        
        }else{  

            $data  = [
            'nombrerol'    => request()->nombrerol,
            'estado'    => request()->estado
            ];
            $guardado=Rol::insert($data);
            //dd();
            if (is_null($guardado)) {
                return redirect('rol')->with('mensaje','No se puedo guardar el registro...');
            }else{
                return redirect('rol')->with('mensaje','Rol guardado...');
            }
        }  
    }

    public function edit($id)
    {
        $rol =Rol::findOrFail($id);
        return view('rol.edit',compact('rol'));
    }

    /** Update the specified resource in storage.
     *  @param  \Illuminate\Http\Request  $request
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
            $datosrol  = [
                'nombrerol'    => request()->nombrerol,
                'estado'    => request()->estado
            ];
                $grabado=Rol::where('idrol','=',$id)->update($datosrol);
                if(is_null($grabado)){
                    return redirect('rol')->with('mensaje','No se pudo guardar el registro!');
                }else{   
                    $datos['rol'] = Rol::paginate(5);
                    return redirect('rol')->with('mensaje','Datos de Rol modificados!');
                }
    }
    public function permisos($id)
    {
        $rol =Rol::findOrFail($id);
        $paginasactuales=Permiso::select('idpagina')->where('idrol',$id)->get()->toArray();

        $paginasdisponibles=Pagina::whereNotIn('idpagina',$paginasactuales)
        ->orderby('nombre', 'asc')
        ->where('estado','ACTIVO')
        ->paginate(5);
        // ->get();
        // dd($paginasdisponibles);
        $permiso = Permiso::select('p.idpermiso','p.idpagina','pa.nombre','p.estado')
        ->from('permiso as p')
        ->join('rol as r','p.idrol','=','r.idrol')
        ->join('pagina as pa','p.idpagina','=','pa.idpagina')
        ->orderBy('pa.nombre', 'asc')
        ->where('r.idrol',$id)
        ->paginate(5);
        // ->get();
                      
        //dd($paginasdisponibles);
        //dd($permiso);
        return view('rol.permisos',compact('rol','paginasdisponibles','permiso'));       
    }
}
