<?php

namespace App\Http\Controllers;

use App\Models\Ciudad;
use App\Models\Empresa;
use App\Models\Sucursal;
use Illuminate\Http\Request;

class SucursalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $sucursales = Sucursal::select('s.idsucursal',
                                        's.nombre',
                                        's.idciudad',
                                        'c.nombre as ciudad',
                                        's.estado',
                                        's.telefono',
                                        's.direccion',
                                        's.idempresa',
                                        'e.nombre as empresa_nombre') 
                                        ->from('sucursal as s')
                                        ->join('empresa as e','s.idempresa','=','e.idempresa')
                                        ->join('ciudad as c','s.idciudad','=','c.idciudad')
                                        ->where(function ($q) {
                                            $q->where('s.idsucursal', 'like', '%' . trim(request()->texto) . '%')
                                            ->orWhere('s.nombre', 'like', '%' . trim(request()->texto) . '%')
                                            ->orWhere('c.nombre', 'like', '%' . trim(request()->texto) . '%')
                                            ->orWhere('s.estado',trim(request()->texto));
                                        })
                                        ->where('s.idempresa', auth()->user()->idempresa) 
                                        ->paginate(5)->withQueryString();
        /*-------------------------------------------------------------*/
        return view('sucursal.index', compact('sucursales','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $ciudades=Ciudad::where('estado','ACTIVO')->get();
        return view('sucursal.create', compact('ciudades'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Sucursal::Where([
            ['nombre', request()->nombre],
            ['idempresa', auth()->user()->idempresa ]            
        ])
        ->first();
        if (is_null($duplicado)) {
            $campos = [
                'nombre' => 'required|string|max:45',
            ];

            $mensaje = [
                'required' => 'El campo "Nombre" es requerido'
            ];

            $this->validate($request, $campos, $mensaje);

            $datosSucursal = request()->except('_token');
            Sucursal::insert($datosSucursal);
            $datos['sucursales'] = Sucursal::paginate(5);
            return redirect('sucursal')->with('mensaje', 'Datos de la Sucursal, guardados correctamente...');
        } else {
            return redirect()->back()->with('mensaje', 'La sucursal ya existe...!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {        
        // $empresas=Empresa::where('activo','SI')->get();
        $sucursales = Sucursal::findOrFail($id);
        $ciudades=Ciudad::where('estado','ACTIVO')->get();
        return view('sucursal.edit', compact('sucursales','ciudades'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Sucursal::Where([
            ['nombre', request()->nombre],
            ['idempresa', auth()->user()->idempresa ],
            ['idsucursal', '!=', $id]
        ])
        ->first();
        if (is_null($duplicado)) {
            $campos = [
                'nombre' => 'required|string|max:45',
            ];

            $mensaje = [
                'required' => 'El campo "Nombre" es requerido'
            ];

            $this->validate($request, $campos, $mensaje);

            $datosSucursal = request()->except(['_token', '_method']);
            Sucursal::where('idsucursal', '=', $id)->update($datosSucursal);
            return redirect('sucursal')->with('mensaje', 'Datos de la Sucursal, editados correctamente...');
        } else {
            return redirect()->back()->with('mensaje', 'La Sucursal ya existe...!');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
