<?php

namespace App\Http\Controllers;

use App\Models\Usuario;
use App\Models\Perfiles;
use App\Models\Rol;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Laracasts\Flash\Flash;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Query\Builder;
use Illuminate\Support\Facades\DB;

class UsuarioController extends Controller
{
    /** Display a listing of the resource.
     * @return \Illuminate\Http\Response
     **/
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $usuarios=Usuario::where('idusuario','like','%'.$texto.'%')
        ->orwhere('nick','like','%'.$texto.'%')
        ->orwhere('nombre','like','%'.$texto.'%')
        ->orwhere('estado',$texto)
        ->paginate(5)->withQueryString();
        return view('usuario.index',compact('usuarios','texto'));
    }

    /** Show the form for creating a new resource
     * @return \Illuminate\Http\Response
     **/
    public function create()
    {
        return view('usuario.create');
    }

    /** Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     **/
    public function store(Request $request)
    {
        //dd(request()->perfiles);

        if (request()->guardaperfiles) {
            //dd(request()->guardaperfiles);
            // dd(request()->perfiles);
            
            foreach (request()->perfiles as $key => $value) {
                // dd($key);
                $detperfil = [
                   'idusuario' => request()->idusuario,
                   'idrol' => $value['idrol'],
                   "perfilestado" => $value['perfilestado'],                        
                    ];
                // dd($detperfil);
                // $resultperfil = Perfiles::insert($detperfil);
                // $resultperfil = Perfiles::updateOrCreate($detperfil);
                $secretaria = Perfiles::updateOrCreate([
                    'idusuario' => request()->idusuario,
                    'idrol' => $value['idrol']], $detperfil); 
                
            }
            return redirect('usuario')->with('mensaje','Perfil actualizado....');
        }else{
        
            $duplicado = Usuario::where('nick', request()->nick)->first();

            if (is_null($duplicado)) {

                $data  = [
                    'nick'      => request()->nick,
                    'nombre'    => request()->nombre,
                    'contrasena'=> Hash::make(trim(request()->contrasena)),
                ];
                Usuario::insert($data);
                //Usuario::insert(request()->except('_token'));
                //dd()
                $datos['usuarios'] = Usuario::paginate(5)->withQueryString();;
                //dd($datos);
                return redirect('usuario')->with('mensaje','Usuario guardado...');
            }else{
                //return redirect('usuario.create')->with('mensaje','Nick de usuario ya existe...');
                return redirect()->back()->with('mensaje','Nick de usuario ya existe...');  
            }
        }
    }

    /** Display the specified resource.
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     **/
    public function show($id)
    {
        //
    }

    /** Show the form for editing the specified resource.
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     **/
    public function edit($id)
    {
        $usuario =Usuario::findOrFail($id);
        return view('usuario.edit',compact('usuario'));
    }

    /** Update the specified resource in storage.
     *  @param  \Illuminate\Http\Request  $request
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     **/
    public function update(Request $request, $id)
    {
        //$datosUsuario=request()->except(['_token','_method']);
        //dd($id);
        //dd(request()->cambiopass);
        if (request()->cambiopass) {
 
            if (request()->contrasena==null) {
                // return redirect('usuario.cambiarpass')->with('El campo "Constraseña" es requerido');
                return redirect()->back()->with('mensaje', 'El campo "Constraseña" es requerido');  
                //return view('usuario.cambiarpass',compact('usuario'));
            
            }else{ 
            
                $solopass  = ['contrasena'=> Hash::make(trim(request()->contrasena))];
                      
                $grabado=Usuario::where('idusuario','=',$id)->update($solopass);
                if(is_null($grabado)){
                    return redirect('usuario')->with('mensaje','Constraseña no cambiada!');
                }else{   
                    // $datos['usuarios'] = Usuario::paginate(5);
                    return redirect('usuario')->with('mensaje','Constraseña cambiada!');
                } 
            }
        }else{

            $duplicado = Usuario::where('nick', request()->nick)
            ->where('idusuario', '!=', $id)
            ->first();

            if (empty($duplicado)) {

                $datosUsuario  = [
                    'nick'      => request()->nick,
                    'nombre'    => request()->nombre,
                    'estado'    => request()->estado
                ];

                Usuario::where('idusuario','=',$id)->update($datosUsuario);
                $datos['usuarios'] = Usuario::paginate(5);
                return redirect('usuario')->with('mensaje','Usuario actualizado correctamente!');
                
            }else{
                return redirect()->back()->with('mensaje','Nick de usuario ya existe...');  
            }
        }
    }

    /** Cambiar the specified resource from storage.
     * @param  int  $id
     * @return \Illuminate\Http\Response
     **/
    public function cambiarpass($id)
    {
        $usuario =Usuario::findOrFail($id);
        //$usuario = Usuario::where('idusuario','=',$id);
        //dd($usuario->activo);
        if(($usuario->estado=='INACTIVO')){
            return redirect('usuario')->with('danger','Estado inactivo de usuario no permite cambio de contraseña!');
        }else{   
            // $datos['usuarios'] = Usuario::paginate(5);
            return view('usuario.cambiarpass',compact('usuario'));
        } 
        
    }
    
    /** Cambiar the specified resource from storage.
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     **/
    public function perfiles($id)
    {
        //dd($id);
        $usuario =Usuario::findOrFail($id);
       
        //$perfilactual = Perfiles::with(['rol'])
        $perfilactual = Perfiles::select('p.idusuario','p.idrol','p.perfilestado','r.nombrerol')
        ->from('perfiles as p')
        ->join('rol as r','p.idrol','=','r.idrol')
        ->where('p.idusuario',$id)
        ->get();
              
        #para listar solo lo disponible
        $perfilasignado = Perfiles::where('idusuario',$id) 
        ->pluck('idrol')->toarray();

        // $roldisponible =Rol::where('estadorol','ACTIVO') -- ********codico corregido
        $roldisponible =Rol::where('estado','ACTIVO')
        ->whereNotIn('idrol',$perfilasignado)
        ->orderby('nombrerol','asc')
        ->get();

        //dd($roldisponible);   
        //dd($perfilactual);   
        //dd($rol);
        return view('usuario.perfiles')
                ->with('usuario',$usuario)
                ->with('perfilactual',$perfilactual)
                ->with('roldisponible',$roldisponible);
        
    }
    
}
