-- --------------------------------------------------------
-- Host:                         172.32.5.52
-- Versión del servidor:         10.4.28-MariaDB - Source distribution
-- SO del servidor:              Linux
-- HeidiSQL Versión:             12.5.0.6677
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Volcando estructura para tabla contapy.asiento
DROP TABLE IF EXISTS `asiento`;
CREATE TABLE IF NOT EXISTS `asiento` (
  `idasiento` int(11) NOT NULL AUTO_INCREMENT,
  `idsucursal` int(11) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `nro_asiento` int(11) NOT NULL,
  `fecha_asiento` date NOT NULL,
  `comentario` text NOT NULL,
  `automatico` varchar(15) NOT NULL,
  PRIMARY KEY (`idasiento`),
  KEY `asiento_FK` (`idempresa`),
  KEY `asiento_FK_1` (`idsucursal`),
  CONSTRAINT `asiento_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`),
  CONSTRAINT `asiento_FK_1` FOREIGN KEY (`idsucursal`) REFERENCES `sucursal` (`idsucursal`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.asiento: ~0 rows (aproximadamente)
DELETE FROM `asiento`;

-- Volcando estructura para tabla contapy.asiento_detalle
DROP TABLE IF EXISTS `asiento_detalle`;
CREATE TABLE IF NOT EXISTS `asiento_detalle` (
  `id_asiento_detalle` int(11) NOT NULL AUTO_INCREMENT,
  `idasiento` int(11) NOT NULL,
  `idcuenta` int(11) NOT NULL,
  `debe` varchar(20) NOT NULL,
  `haber` varchar(20) NOT NULL,
  PRIMARY KEY (`id_asiento_detalle`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.asiento_detalle: ~2 rows (aproximadamente)
DELETE FROM `asiento_detalle`;
INSERT INTO `asiento_detalle` (`id_asiento_detalle`, `idasiento`, `idcuenta`, `debe`, `haber`) VALUES
	(1, 1, 10, '300', '0'),
	(2, 1, 11, '0', '300');

-- Volcando estructura para tabla contapy.balance_general
DROP TABLE IF EXISTS `balance_general`;
CREATE TABLE IF NOT EXISTS `balance_general` (
  `idbalance_general` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_general`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.balance_general: ~0 rows (aproximadamente)
DELETE FROM `balance_general`;

-- Volcando estructura para tabla contapy.balance_sumas_saldos
DROP TABLE IF EXISTS `balance_sumas_saldos`;
CREATE TABLE IF NOT EXISTS `balance_sumas_saldos` (
  `idbalance_sumas_saldos` int(11) NOT NULL AUTO_INCREMENT,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_sumas_saldos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.balance_sumas_saldos: ~0 rows (aproximadamente)
DELETE FROM `balance_sumas_saldos`;

-- Volcando estructura para tabla contapy.ciudad
DROP TABLE IF EXISTS `ciudad`;
CREATE TABLE IF NOT EXISTS `ciudad` (
  `idciudad` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `activo` binary(1) DEFAULT '1' COMMENT '0=Inactivo\n1 = Activo',
  PRIMARY KEY (`idciudad`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Volcando datos para la tabla contapy.ciudad: ~19 rows (aproximadamente)
DELETE FROM `ciudad`;
INSERT INTO `ciudad` (`idciudad`, `nombre`, `activo`) VALUES
	(1, 'Asunción', _binary 0x31),
	(2, 'Lambaré', _binary 0x31),
	(3, 'Capiatá', _binary 0x31),
	(4, 'Luque', _binary 0x31),
	(5, 'San Antonio', _binary 0x31),
	(6, 'Ñemby', _binary 0x31),
	(7, 'Ypané', _binary 0x31),
	(8, 'San Lorenzo', _binary 0x30),
	(9, 'Mariano R. Alonzo', _binary 0x31),
	(10, 'Ciudad del Este', _binary 0x31),
	(11, 'Coronel Oviedo', _binary 0x31),
	(12, 'Fernando de la Mora', _binary 0x31),
	(13, 'Villa elisa', _binary 0x31),
	(14, 'Guarambaré', _binary 0x31),
	(15, 'Limpio', _binary 0x31),
	(16, 'Villeta', _binary 0x31),
	(17, 'Mauricio J. Troche', _binary 0x31),
	(18, 'Paraguarí', _binary 0x31),
	(19, 'Desconocida', _binary 0x31);

-- Volcando estructura para tabla contapy.cliente
DROP TABLE IF EXISTS `cliente`;
CREATE TABLE IF NOT EXISTS `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `idcuenta` int(11) NOT NULL,
  `nombre` varchar(25) NOT NULL,
  `apellido` varchar(25) NOT NULL,
  `ruc` varchar(30) DEFAULT NULL,
  `activo` binary(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.cliente: ~2 rows (aproximadamente)
DELETE FROM `cliente`;
INSERT INTO `cliente` (`idcliente`, `idcuenta`, `nombre`, `apellido`, `ruc`, `activo`) VALUES
	(1, 11, 'Hugo', 'Gomez', '123456', _binary 0x31),
	(3, 10, 'gpmez', 'gdddgd5', '58658', _binary 0x31);

-- Volcando estructura para tabla contapy.cuenta
DROP TABLE IF EXISTS `cuenta`;
CREATE TABLE IF NOT EXISTS `cuenta` (
  `idcuenta` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(30) NOT NULL,
  `tipo_saldo` smallint(6) NOT NULL DEFAULT 0,
  `imputable` varchar(30) NOT NULL,
  `tipo_actividad` smallint(6) NOT NULL,
  `clasificacion` smallint(6) NOT NULL,
  `presupuestable` tinyint(1) DEFAULT NULL COMMENT 'Un indicador de si la cuenta es presupuestable o no (1,0)',
  `nivel` int(11) NOT NULL,
  `fecha_creacion` datetime NOT NULL,
  `usuario_creacion` int(11) NOT NULL,
  UNIQUE KEY `cuenta_pk` (`idcuenta`,`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.cuenta: ~0 rows (aproximadamente)
DELETE FROM `cuenta`;

-- Volcando estructura para tabla contapy.cuenta_set
DROP TABLE IF EXISTS `cuenta_set`;
CREATE TABLE IF NOT EXISTS `cuenta_set` (
  `idcuenta_set` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `nombre` varchar(25) NOT NULL,
  `condicion` tinytext NOT NULL,
  PRIMARY KEY (`idcuenta_set`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.cuenta_set: ~2 rows (aproximadamente)
DELETE FROM `cuenta_set`;
INSERT INTO `cuenta_set` (`idcuenta_set`, `codigo`, `nombre`, `condicion`) VALUES
	(1, '54545', 'wefwefw', '1'),
	(2, '001002', 'corriente', '1');

-- Volcando estructura para tabla contapy.empresa
DROP TABLE IF EXISTS `empresa`;
CREATE TABLE IF NOT EXISTS `empresa` (
  `idempresa` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(200) NOT NULL,
  `ruc` varchar(25) NOT NULL,
  `direccion` varchar(200) NOT NULL,
  `telefono` varchar(50) NOT NULL,
  `representante_legal` varchar(200) NOT NULL,
  `representante_ruc` varchar(25) NOT NULL,
  `contador` varchar(200) NOT NULL,
  `contador_ruc` varchar(25) NOT NULL,
  `pedriodo_actual` int(11) DEFAULT NULL,
  `periodo_inicial` date NOT NULL,
  `periodo_final` date NOT NULL,
  `condicion` tinyint(4) NOT NULL DEFAULT 0,
  `activo` binary(1) DEFAULT '1' COMMENT '0 = Inactivo\n1 = Activo',
  PRIMARY KEY (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.empresa: ~2 rows (aproximadamente)
DELETE FROM `empresa`;
INSERT INTO `empresa` (`idempresa`, `nombre`, `ruc`, `direccion`, `telefono`, `representante_legal`, `representante_ruc`, `contador`, `contador_ruc`, `pedriodo_actual`, `periodo_inicial`, `periodo_final`, `condicion`, `activo`) VALUES
	(1, 'A M Reguera  S. R. L.', '4777170-4', 'Bertoni', '0983535388', 'Augusto Saldivar', '1258300-4', 'Vicente Sanchez', '1566223', 2020, '2020-11-05', '2020-11-08', 1, _binary 0x31),
	(2, 'Luisito S.A.', '78800666-4', 'Avda. Felix Bogado c/ Japón', '021369852', 'Victor Jesús Peña', '1245789-4', 'Fatima Ocampos', '2563214', NULL, '2023-10-06', '2023-10-06', 0, _binary 0x31);

-- Volcando estructura para tabla contapy.estado_de_resultado
DROP TABLE IF EXISTS `estado_de_resultado`;
CREATE TABLE IF NOT EXISTS `estado_de_resultado` (
  `idestado_de_resultado` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idestado_de_resultado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.estado_de_resultado: ~0 rows (aproximadamente)
DELETE FROM `estado_de_resultado`;

-- Volcando estructura para tabla contapy.flujo_de_efectivo
DROP TABLE IF EXISTS `flujo_de_efectivo`;
CREATE TABLE IF NOT EXISTS `flujo_de_efectivo` (
  `idflujo_de_efectivo` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idflujo_de_efectivo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.flujo_de_efectivo: ~0 rows (aproximadamente)
DELETE FROM `flujo_de_efectivo`;

-- Volcando estructura para tabla contapy.libro_compra
DROP TABLE IF EXISTS `libro_compra`;
CREATE TABLE IF NOT EXISTS `libro_compra` (
  `idlibro_compra` int(11) NOT NULL AUTO_INCREMENT,
  `idproveedor` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `comprobante` varchar(25) NOT NULL,
  `nro_comprobante` varchar(35) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `condicion` varchar(20) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `timbrado` decimal(30,0) NOT NULL,
  `gravada5` decimal(50,0) NOT NULL,
  `gravada10` decimal(50,0) NOT NULL,
  `iva5` decimal(50,0) NOT NULL,
  `iva10` decimal(50,0) NOT NULL,
  `total` decimal(50,0) NOT NULL,
  PRIMARY KEY (`idlibro_compra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.libro_compra: ~0 rows (aproximadamente)
DELETE FROM `libro_compra`;

-- Volcando estructura para tabla contapy.libro_diario
DROP TABLE IF EXISTS `libro_diario`;
CREATE TABLE IF NOT EXISTS `libro_diario` (
  `idlibro_diario` int(11) NOT NULL AUTO_INCREMENT,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `cod_cuenta` varchar(20) NOT NULL,
  `cuenta` varchar(45) NOT NULL,
  `debe` varchar(45) NOT NULL,
  `haber` varchar(45) NOT NULL,
  PRIMARY KEY (`idlibro_diario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.libro_diario: ~0 rows (aproximadamente)
DELETE FROM `libro_diario`;

-- Volcando estructura para tabla contapy.libro_mayor
DROP TABLE IF EXISTS `libro_mayor`;
CREATE TABLE IF NOT EXISTS `libro_mayor` (
  `idlibro_mayor` int(11) NOT NULL AUTO_INCREMENT,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `cod_cuenta` varchar(25) NOT NULL,
  `saldo` decimal(10,0) NOT NULL,
  PRIMARY KEY (`idlibro_mayor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.libro_mayor: ~0 rows (aproximadamente)
DELETE FROM `libro_mayor`;

-- Volcando estructura para tabla contapy.libro_venta
DROP TABLE IF EXISTS `libro_venta`;
CREATE TABLE IF NOT EXISTS `libro_venta` (
  `idlibro_venta` int(11) NOT NULL AUTO_INCREMENT,
  `idplan_de_cuenta` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `comprobante` varchar(25) NOT NULL,
  `nro_comprobante` decimal(25,0) NOT NULL,
  `descripcion` varchar(45) NOT NULL,
  `condicion` varchar(25) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `gravada5` decimal(50,0) NOT NULL,
  `gravada10` decimal(50,0) NOT NULL,
  `iva5` decimal(35,0) NOT NULL,
  `iva10` decimal(35,0) NOT NULL,
  `total` decimal(50,0) NOT NULL,
  PRIMARY KEY (`idlibro_venta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.libro_venta: ~0 rows (aproximadamente)
DELETE FROM `libro_venta`;

-- Volcando estructura para tabla contapy.pagina
DROP TABLE IF EXISTS `pagina`;
CREATE TABLE IF NOT EXISTS `pagina` (
  `idpagina` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `activo` bit(1) NOT NULL,
  PRIMARY KEY (`idpagina`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de las interfaces de usuario con un nombre donde primero se ingresa para luego realizar operaciones.';

-- Volcando datos para la tabla contapy.pagina: ~0 rows (aproximadamente)
DELETE FROM `pagina`;

-- Volcando estructura para tabla contapy.patrimonio
DROP TABLE IF EXISTS `patrimonio`;
CREATE TABLE IF NOT EXISTS `patrimonio` (
  `idpatrimonio` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  PRIMARY KEY (`idpatrimonio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.patrimonio: ~0 rows (aproximadamente)
DELETE FROM `patrimonio`;

-- Volcando estructura para tabla contapy.permiso
DROP TABLE IF EXISTS `permiso`;
CREATE TABLE IF NOT EXISTS `permiso` (
  `idpermiso` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(20) NOT NULL,
  PRIMARY KEY (`idpermiso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.permiso: ~0 rows (aproximadamente)
DELETE FROM `permiso`;

-- Volcando estructura para tabla contapy.proveedor
DROP TABLE IF EXISTS `proveedor`;
CREATE TABLE IF NOT EXISTS `proveedor` (
  `idproveedor` int(11) NOT NULL AUTO_INCREMENT,
  `idcuenta` int(11) NOT NULL,
  `ruc` varchar(25) DEFAULT NULL,
  `razon_social` varchar(35) DEFAULT NULL,
  `direccion` varchar(35) DEFAULT NULL,
  `telefono` varchar(20) NOT NULL,
  `activo` binary(1) NOT NULL DEFAULT '1' COMMENT '0= Inactivo\n1= Activo',
  PRIMARY KEY (`idproveedor`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.proveedor: ~2 rows (aproximadamente)
DELETE FROM `proveedor`;
INSERT INTO `proveedor` (`idproveedor`, `idcuenta`, `ruc`, `razon_social`, `direccion`, `telefono`, `activo`) VALUES
	(2, 10, 'hgfcg', 'Hugo Enrique Gomez', 'gfyhg', '3232', _binary 0x31),
	(4, 10, '4864', 'sdff', 'fvdgf', '2165', _binary 0x31);

-- Volcando estructura para tabla contapy.rol
DROP TABLE IF EXISTS `rol`;
CREATE TABLE IF NOT EXISTS `rol` (
  `idrol` int(11) NOT NULL,
  `nombrerol` varchar(50) NOT NULL,
  `activo` bit(1) NOT NULL DEFAULT b'0',
  `fecha_creacion` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fecha_modificacion` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idrol`),
  UNIQUE KEY `nombrerol` (`nombrerol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de los roles de usuarios';

-- Volcando datos para la tabla contapy.rol: ~0 rows (aproximadamente)
DELETE FROM `rol`;

-- Volcando estructura para tabla contapy.sucursal
DROP TABLE IF EXISTS `sucursal`;
CREATE TABLE IF NOT EXISTS `sucursal` (
  `idsucursal` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `condicion` tinyint(4) NOT NULL DEFAULT 1,
  `activo` binary(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`idsucursal`),
  KEY `sucursal_FK` (`idempresa`),
  CONSTRAINT `sucursal_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Volcando datos para la tabla contapy.sucursal: ~3 rows (aproximadamente)
DELETE FROM `sucursal`;
INSERT INTO `sucursal` (`idsucursal`, `nombre`, `idempresa`, `condicion`, `activo`) VALUES
	(1, 'Casa Matriz 2', 1, 1, _binary 0x31),
	(2, 'E. Ayala aaa', 1, 1, _binary 0x31),
	(4, 'Sucursal 1', 1, 1, _binary 0x31);

-- Volcando estructura para tabla contapy.usuario
DROP TABLE IF EXISTS `usuario`;
CREATE TABLE IF NOT EXISTS `usuario` (
  `idusuario` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identificador único del registro de usuario',
  `nick` varchar(50) NOT NULL DEFAULT '' COMMENT 'Nombre identificador unico del usuario',
  `nombre` varchar(50) NOT NULL COMMENT 'Apellido del usuario',
  `contrasena` varchar(200) NOT NULL COMMENT 'Palabra de paso de ingreso al sistema.',
  `intento_fallido` int(11) NOT NULL DEFAULT 0,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Fecha de creación del registro',
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Fecha de modificacion del registro.',
  `activo` binary(1) NOT NULL DEFAULT '1' COMMENT '0=Inactivo, 1=Activo',
  PRIMARY KEY (`idusuario`),
  UNIQUE KEY `nick` (`nick`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Tabla que permite guardar los registros de usuarios del sistema. ';

-- Volcando datos para la tabla contapy.usuario: ~2 rows (aproximadamente)
DELETE FROM `usuario`;
INSERT INTO `usuario` (`idusuario`, `nick`, `nombre`, `contrasena`, `intento_fallido`, `fecha_creacion`, `fecha_modificacion`, `activo`) VALUES
	(1, 'admin', 'Administrador del Sistema', '$2y$10$aZiEwmeM/O1enb9vnz3R9.7XILHYSafE/ajjfhKOFO2WLJjQImsnm', 0, '2023-10-03 23:44:02', '2023-10-03 23:33:34', _binary 0x31),
	(2, 'robertmac', 'Robert Plant', '$2y$10$FNaAOm82XTWX0n2P8GJL6OQ7zl355kRpV2fDX3MO4vuRzsgekJXhW', 0, '2023-10-03 23:38:38', '2023-10-03 23:35:26', _binary 0x31);

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
