/*
SQLyog Community v13.2.0 (64 bit)
MySQL - 10.4.28-MariaDB : Database - contapy
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`contapy` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;

USE `contapy`;

/*Table structure for table `asiento` */

DROP TABLE IF EXISTS `asiento`;

CREATE TABLE `asiento` (
  `idasiento` int(11) NOT NULL AUTO_INCREMENT,
  `idsucursal` int(11) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `nro_asiento` int(11) NOT NULL,
  `fecha_asiento` date NOT NULL,
  `comentario` text NOT NULL,
  `automatico` varchar(15) NOT NULL,
  PRIMARY KEY (`idasiento`),
  KEY `asiento_FK` (`idempresa`),
  KEY `asiento_FK_1` (`idsucursal`),
  CONSTRAINT `asiento_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`),
  CONSTRAINT `asiento_FK_1` FOREIGN KEY (`idsucursal`) REFERENCES `sucursal` (`idsucursal`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `asiento` */

/*Table structure for table `asiento_detalle` */

DROP TABLE IF EXISTS `asiento_detalle`;

CREATE TABLE `asiento_detalle` (
  `id_asiento_detalle` int(11) NOT NULL AUTO_INCREMENT,
  `idasiento` int(11) NOT NULL,
  `idcuenta` int(11) NOT NULL,
  `debe` varchar(20) NOT NULL,
  `haber` varchar(20) NOT NULL,
  PRIMARY KEY (`id_asiento_detalle`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `asiento_detalle` */

insert  into `asiento_detalle`(`id_asiento_detalle`,`idasiento`,`idcuenta`,`debe`,`haber`) values 
(1,1,10,'300','0'),
(2,1,11,'0','300');

/*Table structure for table `balance_general` */

DROP TABLE IF EXISTS `balance_general`;

CREATE TABLE `balance_general` (
  `idbalance_general` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_general`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `balance_general` */

/*Table structure for table `balance_sumas_saldos` */

DROP TABLE IF EXISTS `balance_sumas_saldos`;

CREATE TABLE `balance_sumas_saldos` (
  `idbalance_sumas_saldos` int(11) NOT NULL AUTO_INCREMENT,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_sumas_saldos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `balance_sumas_saldos` */

/*Table structure for table `ciudad` */

DROP TABLE IF EXISTS `ciudad`;

CREATE TABLE `ciudad` (
  `idciudad` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `activo` binary(1) DEFAULT '1' COMMENT '0=Inactivo\n1 = Activo',
  PRIMARY KEY (`idciudad`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `ciudad` */

insert  into `ciudad`(`idciudad`,`nombre`,`activo`) values 
(1,'Asunción','1'),
(2,'Lambaré','1'),
(3,'Capiatá','1'),
(4,'Luque','1'),
(5,'San Antonio','1'),
(6,'Ñemby','1'),
(7,'Ypané','1'),
(8,'San Lorenzo','0'),
(9,'Mariano R. Alonzo','1'),
(10,'Ciudad del Este','1'),
(11,'Coronel Oviedo','1'),
(12,'Fernando de la Mora','1'),
(13,'Villa elisa','1'),
(14,'Guarambaré','1'),
(15,'Limpio','1'),
(16,'Villeta','1'),
(17,'Mauricio J. Troche','1'),
(18,'Paraguarí','1'),
(19,'Desconocida','1');

/*Table structure for table `cliente` */

DROP TABLE IF EXISTS `cliente`;

CREATE TABLE `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `idcuenta` int(11) NOT NULL,
  `nombre` varchar(25) NOT NULL,
  `apellido` varchar(25) NOT NULL,
  `ruc` varchar(30) DEFAULT NULL,
  `activo` binary(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `cliente` */

insert  into `cliente`(`idcliente`,`idcuenta`,`nombre`,`apellido`,`ruc`,`activo`) values 
(1,11,'Hugo','Gomez','123456','1'),
(3,10,'gpmez','gdddgd5','58658','1');

/*Table structure for table `cuenta` */

DROP TABLE IF EXISTS `cuenta`;

CREATE TABLE `cuenta` (
  `idcuenta` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(30) NOT NULL,
  `tipo_saldo` set('NO IMPUTABLE','DEUDOR','ACREEDOR') NOT NULL COMMENT '0 no imputable - 1 deudor - 2 acreedor',
  `imputable` set('SI','NO') NOT NULL DEFAULT 'NO',
  `tipo_actividad` set('OPERATIVA','INVERSIONES','FINANCIAMIENTO') NOT NULL COMMENT '1. Operativa 2.Inversiones 3.Financiemiento',
  `clasificacion` set('ACTIVO','PASIVO','PATRIMONIO NETO','INGRESO','EGRESO','ORDEN') NOT NULL COMMENT 'Un clasificador de Niveles como',
  `presupuestable` set('SI','NO') DEFAULT NULL COMMENT 'Un indicador de si la cuenta es presupuestable o no (1,0)',
  `nivel` int(11) NOT NULL,
  `fecha_creacion` datetime NOT NULL DEFAULT current_timestamp(),
  `usuario_creacion` int(11) NOT NULL,
  `activo` binary(1) NOT NULL DEFAULT '1',
  UNIQUE KEY `cuenta_pk` (`idcuenta`,`idempresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `cuenta` */

/*Table structure for table `empresa` */

DROP TABLE IF EXISTS `empresa`;

CREATE TABLE `empresa` (
  `idempresa` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(200) NOT NULL,
  `ruc` varchar(25) NOT NULL,
  `direccion` varchar(200) NOT NULL,
  `telefono` varchar(50) NOT NULL,
  `representante_legal` varchar(200) NOT NULL,
  `representante_ruc` varchar(25) NOT NULL,
  `contador` varchar(200) NOT NULL,
  `contador_ruc` varchar(25) NOT NULL,
  `pedriodo_actual` int(11) DEFAULT NULL,
  `periodo_inicial` date NOT NULL,
  `periodo_final` date NOT NULL,
  `activo` binary(1) DEFAULT '1' COMMENT '0 = Inactivo\n1 = Activo',
  PRIMARY KEY (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `empresa` */

insert  into `empresa`(`idempresa`,`nombre`,`ruc`,`direccion`,`telefono`,`representante_legal`,`representante_ruc`,`contador`,`contador_ruc`,`pedriodo_actual`,`periodo_inicial`,`periodo_final`,`activo`) values 
(1,'A M Reguera  S. R. L.','4777170-4','Bertoni','0983535388','Augusto Saldivar','1258300-4','Vicente Sanchez','1566223',2020,'2020-11-05','2020-11-08','1'),
(2,'Luisito S.A.','78800666-4','Avda. Felix Bogado c/ Japón','021369852','Victor Jesús Peña','1245789-4','Fatima Ocampos','2563214',NULL,'2023-10-06','2023-10-06','1');

/*Table structure for table `estado_de_resultado` */

DROP TABLE IF EXISTS `estado_de_resultado`;

CREATE TABLE `estado_de_resultado` (
  `idestado_de_resultado` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idestado_de_resultado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `estado_de_resultado` */

/*Table structure for table `flujo_de_efectivo` */

DROP TABLE IF EXISTS `flujo_de_efectivo`;

CREATE TABLE `flujo_de_efectivo` (
  `idflujo_de_efectivo` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idflujo_de_efectivo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `flujo_de_efectivo` */

/*Table structure for table `libro_compra` */

DROP TABLE IF EXISTS `libro_compra`;

CREATE TABLE `libro_compra` (
  `idlibro_compra` int(11) NOT NULL AUTO_INCREMENT,
  `idproveedor` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `comprobante` varchar(25) NOT NULL,
  `nro_comprobante` varchar(35) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `condicion` varchar(20) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `timbrado` decimal(30,0) NOT NULL,
  `gravada5` decimal(50,0) NOT NULL,
  `gravada10` decimal(50,0) NOT NULL,
  `iva5` decimal(50,0) NOT NULL,
  `iva10` decimal(50,0) NOT NULL,
  `total` decimal(50,0) NOT NULL,
  PRIMARY KEY (`idlibro_compra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `libro_compra` */

/*Table structure for table `libro_diario` */

DROP TABLE IF EXISTS `libro_diario`;

CREATE TABLE `libro_diario` (
  `idlibro_diario` int(11) NOT NULL AUTO_INCREMENT,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `cod_cuenta` varchar(20) NOT NULL,
  `cuenta` varchar(45) NOT NULL,
  `debe` varchar(45) NOT NULL,
  `haber` varchar(45) NOT NULL,
  PRIMARY KEY (`idlibro_diario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `libro_diario` */

/*Table structure for table `libro_mayor` */

DROP TABLE IF EXISTS `libro_mayor`;

CREATE TABLE `libro_mayor` (
  `idlibro_mayor` int(11) NOT NULL AUTO_INCREMENT,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `cod_cuenta` varchar(25) NOT NULL,
  `saldo` decimal(10,0) NOT NULL,
  PRIMARY KEY (`idlibro_mayor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `libro_mayor` */

/*Table structure for table `libro_venta` */

DROP TABLE IF EXISTS `libro_venta`;

CREATE TABLE `libro_venta` (
  `idlibro_venta` int(11) NOT NULL AUTO_INCREMENT,
  `idplan_de_cuenta` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `comprobante` varchar(25) NOT NULL,
  `nro_comprobante` decimal(25,0) NOT NULL,
  `descripcion` varchar(45) NOT NULL,
  `condicion` varchar(25) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `gravada5` decimal(50,0) NOT NULL,
  `gravada10` decimal(50,0) NOT NULL,
  `iva5` decimal(35,0) NOT NULL,
  `iva10` decimal(35,0) NOT NULL,
  `total` decimal(50,0) NOT NULL,
  PRIMARY KEY (`idlibro_venta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `libro_venta` */

/*Table structure for table `pagina` */

DROP TABLE IF EXISTS `pagina`;

CREATE TABLE `pagina` (
  `idpagina` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `activo` bit(1) NOT NULL,
  PRIMARY KEY (`idpagina`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de las interfaces de usuario con un nombre donde primero se ingresa para luego realizar operaciones.';

/*Data for the table `pagina` */

/*Table structure for table `patrimonio` */

DROP TABLE IF EXISTS `patrimonio`;

CREATE TABLE `patrimonio` (
  `idpatrimonio` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  PRIMARY KEY (`idpatrimonio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `patrimonio` */

/*Table structure for table `permiso` */

DROP TABLE IF EXISTS `permiso`;

CREATE TABLE `permiso` (
  `idpermiso` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(20) NOT NULL,
  PRIMARY KEY (`idpermiso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `permiso` */

/*Table structure for table `proveedor` */

DROP TABLE IF EXISTS `proveedor`;

CREATE TABLE `proveedor` (
  `idproveedor` int(11) NOT NULL AUTO_INCREMENT,
  `idcuenta` int(11) NOT NULL,
  `ruc` varchar(25) DEFAULT NULL,
  `razon_social` varchar(35) DEFAULT NULL,
  `direccion` varchar(35) DEFAULT NULL,
  `telefono` varchar(20) NOT NULL,
  `activo` binary(1) NOT NULL DEFAULT '1' COMMENT '0= Inactivo\n1= Activo',
  PRIMARY KEY (`idproveedor`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `proveedor` */

insert  into `proveedor`(`idproveedor`,`idcuenta`,`ruc`,`razon_social`,`direccion`,`telefono`,`activo`) values 
(2,10,'hgfcg','Hugo Enrique Gomez','gfyhg','3232','1'),
(4,10,'4864','sdff','fvdgf','2165','1');

/*Table structure for table `rol` */

DROP TABLE IF EXISTS `rol`;

CREATE TABLE `rol` (
  `idrol` int(11) NOT NULL,
  `nombrerol` varchar(50) NOT NULL,
  `activo` bit(1) NOT NULL DEFAULT b'0',
  `fecha_creacion` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fecha_modificacion` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idrol`),
  UNIQUE KEY `nombrerol` (`nombrerol`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de los roles de usuarios';

/*Data for the table `rol` */

/*Table structure for table `sucursal` */

DROP TABLE IF EXISTS `sucursal`;

CREATE TABLE `sucursal` (
  `idsucursal` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `condicion` tinyint(4) NOT NULL DEFAULT 1,
  `activo` binary(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`idsucursal`),
  KEY `sucursal_FK` (`idempresa`),
  CONSTRAINT `sucursal_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/*Data for the table `sucursal` */

insert  into `sucursal`(`idsucursal`,`nombre`,`idempresa`,`condicion`,`activo`) values 
(1,'Casa Matriz 2',1,1,'1'),
(2,'E. Ayala aaa',1,1,'1'),
(4,'Sucursal 1',1,1,'1');

/*Table structure for table `usuario` */

DROP TABLE IF EXISTS `usuario`;

CREATE TABLE `usuario` (
  `idusuario` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identificador único del registro de usuario',
  `nick` varchar(50) NOT NULL DEFAULT '' COMMENT 'Nombre identificador unico del usuario',
  `nombre` varchar(50) NOT NULL COMMENT 'Apellido del usuario',
  `contrasena` varchar(200) NOT NULL COMMENT 'Palabra de paso de ingreso al sistema.',
  `intento_fallido` int(11) NOT NULL DEFAULT 0,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Fecha de creación del registro',
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Fecha de modificacion del registro.',
  `activo` binary(1) NOT NULL DEFAULT '1' COMMENT '0=Inactivo, 1=Activo',
  PRIMARY KEY (`idusuario`),
  UNIQUE KEY `nick` (`nick`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Tabla que permite guardar los registros de usuarios del sistema. ';

/*Data for the table `usuario` */

insert  into `usuario`(`idusuario`,`nick`,`nombre`,`contrasena`,`intento_fallido`,`fecha_creacion`,`fecha_modificacion`,`activo`) values 
(1,'admin','Administrador del Sistema','$2y$10$aZiEwmeM/O1enb9vnz3R9.7XILHYSafE/ajjfhKOFO2WLJjQImsnm',0,'2023-10-03 20:44:02','2023-10-03 20:33:34','1'),
(2,'robertmac','Robert Plant','$2y$10$FNaAOm82XTWX0n2P8GJL6OQ7zl355kRpV2fDX3MO4vuRzsgekJXhW',0,'2023-10-03 20:38:38','2023-10-03 20:35:26','1');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
