@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if(count($errors)>0)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{$error}}</li>             
            @endforeach
        </ul>
    </div>
    @endif
    @if(Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{Session::get('mensaje')}}
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{url('/articulo')}}" method="post">
        @csrf    
        <div class="card-header">
            <h4>Registrar un Artículo</h4>
        </div>
        <div class="card-body">            
            <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">   
            <div class="row mb-2 mt-2">
                <div class="col-md-4">
                    <label><b>Nombre</b></label>
                    <input type="text" class="form-control form-control-sm" name="nombre" value="{{isset($ciudad->nombre)?$ciudad->nombre:''}}" id="nombre" autocomplete="off">
                </div>
                <div class="col-md-4">
                    <label for="" class="text-dark"><b>Cuenta</b></label>
                    <div class="input-group">
                        <select id="idcuenta" name="idcuenta" class="form-select form-control-sm" style="width: 340px">
                            @foreach ($cuentas as $cuenta)
                                <option value="{{ $cuenta['idcuenta'] }}">
                                    {{ $cuenta['nombre'] }}</option>
                            @endforeach
                        </select>
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                            data-bs-target="#ModalNuevoBeneficiario">
                            +
                        </button>
                    </div>
                    <script>
                        $(document).ready(function() {
                            $('#idcuenta').select2();
                        });
                    </script>
                </div>
                <div class="col-md-4">
                    <label><b>Nota</b></label>
                    <textarea class="form-control form-control-sm" rows="2"></textarea>
                </div>
            </div>
            
        </div>
        <div class="card-footer" align="right">
            <a href="{{url('/articulo')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
            <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
        </div>
    </form>
    </div>
@endsection