@extends('layout.main')
@section('contenido')
    @if (Session::has('mensaje'))
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>{{ Session::get('mensaje') }}</strong>
        </div>
    @endif
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Asiento</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search"
                            placeholder="Buscar" aria-label="Buscar" value="{{ $texto }}">
                        <button class="btn btn-secondary me-2" type="submit">Buscar</button>
                        <a href="{{ url('/asiento/create') }}" class="btn btn-primary btn">Nuevo</a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-sm table-condensed table-striped">
                <thead>
                    <tr class="table-primary">
                        <th>
                            <div align="center">ID</div>
                        </th>
                        <th>Empresa</th>
                        <th>Sucursal</th>
                        <th>Fecha</th>
                        <th>Nº Asiento</th>
                        <th>
                            <div align="center">Acciones</div>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($asientos as $asiento)
                        <tr>
                            <td width=10% align="center">{{ $asiento->idasiento }}</td>
                            <td>{{ $asiento->nro_asiento }}</td>
                            <td>{{ date('d/m/Y', strtotime($asiento->fecha_asiento)) }}</td>
                            <td>
                                @foreach ($empresas as $empresa)
                                    @if ($asiento->idempresa == $empresa->idempresa)
                                        {{ $empresa->nombre }}
                                    @endif
                                @endforeach
                            </td>
                            <td>
                                @foreach ($sucursales as $sucursal)
                                    @if ($asiento->idsucursal == $sucursal->idsucursal)
                                        {{ $sucursal->nombre }}
                                    @endif
                                @endforeach
                            </td>
                            <td width=8% align="center">
                                @php
                                    echo '<a href="asiento/'.$asiento->idasiento.'" class="btn btn-success btn-sm"><i class="fas fa-info"></i></a>';
                                @endphp
                                <a href="{{ url('/asiento/' . $asiento->idasiento . '/edit') }}" class="btn btn-warning btn-sm">
                                    <i class="fas fa-pen fa-lg" title="Editar" style="cursor: pointer"></i>
                                </a>
                                {{-- <form action="{{route('ciudad.destroy',$ciudad->idciudad)}}" method="POST">
                            @csrf
                            @method('DELETE')
                            <input type="submit" class="btn btn-danger btn-sm" value="Borrar" onclick="return confirm('Quieres borrar?')">
                        </form> --}}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $asientos->links() !!}
        </div>
    </div>
@endsection
