<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ env('APP_NAME') }} | Log in</title>
    <!-- Font Awesome -->
    {{-- <link rel="stylesheet" href="{{ url('/assets/plugins/fontawesome-free/css/all.min.css') }}"> --}}
    <link rel="stylesheet" href="{{ url('/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ url('/iconos/bootstrap-icons.min.css') }}">
    {{-- <link rel="stylesheet" href="{{ url('/css/bootstrap.css') }}"> --}}
</head>

<body class="hold-transition login-page">
    <br>
    <div class="container">
        <div class="login-box">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header text-center bg-dark text-white">
                            {{ env('APP_NAME') }} | Acceso
                        </div>
                        @if(Session::has('mensaje'))
                            <div class="alert alert-danger alert-dismissible fade show m-2" role="alert">
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                <strong>Atención: </strong>{{Session::get('mensaje')}}
                            </div>
                        @endif
                        <div class="card-body">
                            <form method="POST" action="{{ route('login') }}">
                                @csrf
                                <div class="row mb-3">
                                    <label for="email"
                                        class="col-md-4 col-form-label text-md-end"><b>{{ __('Usuario') }}</b></label>

                                    <div class="col-md-6">
                                        <input id="nick" type="text" class="form-control" name="nick" required autocomplete="off" autofocus>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <label for="password"
                                        class="col-md-4 col-form-label text-md-end"><b>{{ __('Contraseña') }}</b></label>

                                    <div class="col-md-6">
                                        <input id="contrasena" type="password"
                                            class="form-control @error('constrasena') is-invalid @enderror"
                                            name="contrasena" required autocomplete="current-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                               
                                <div class="row mb-0">
                                    <div class="col-md-8 offset-md-4">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-person-check"></i> <b>{{ __('Ingresar') }}</b>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
    <script src="{{ asset('/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('/js/jquery-3.6.0.min.js') }}"></script>
</html>
