@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if(count($errors)>0)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{$error}}</li>             
            @endforeach
        </ul>
    </div>
    @endif
    @if(Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{Session::get('mensaje')}}
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{url('/ciudad')}}" method="post">
        @csrf    
        <div class="card-header">
            <h4>Registrar una nueva Ciudad</h4>
        </div>
        <div class="card-body">            
            <div class="mb-2 mt-2 col-md-4">
                <label><b>Nombre</b></label>
                <input type="text" class="form-control" name="nombre" value="{{isset($ciudad->nombre)?$ciudad->nombre:''}}" id="nombre" autocomplete="off">
            </div>
        </div>
        <div class="card-footer" align="right">
            <a href="{{url('/ciudad')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
            <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
        </div>
    </form>
    </div>
@endsection