@extends('layout.main')
@section('contenido')
@if(Session::has('mensaje'))
    <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <strong>Ok. </strong>{{Session::get('mensaje')}}
    </div>
@endif
<div class="card mb-2">
    <div class="card-header">
        <div class="navbar">
            <div class="col-md-4" align="left">
                <h4>Lista de Ciudades</h4>
            </div>
            <div class="col-md-4">
                <form class="d-flex" role="search">
                    <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="{{$texto}}">
                    <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="{{url('/ciudad/create')}}" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                </form>
            </div>
        </div>        
    </div>
    <div class="card-body">
        <table class="table table-sm table-condensed table-striped table-bordered">
            <thead class="table-primary">
                <tr>
                    {{-- <th><div align="center">ID</div></th>     --}}
                    <th>Descripción</th>
                    <th width="7%"><div align="center">Estado</div></th>
                    <th width="5%"><div align="center">Acciones</div></th>
                </tr>
            </thead>
            <tbody>
                @foreach($ciudades as $ciudad)
                <tr>
                    {{-- <td width=10% align="center">{{$ciudad->idciudad}}</td> --}}
                    <td>{{$ciudad->nombre}}</td>
                    <td align="center">
                        @if ($ciudad->estado == 'ACTIVO' )
                            ACTIVO
                        @else
                            INACTIVO
                        @endif
                    </td>
                    <td width=8% align="center">
                        <a href="{{url('/ciudad/'.$ciudad->idciudad.'/edit')}}" class="btn btn-warning btn-sm" title="Editar">
                            <i class="bi bi-pencil-fill" style="cursor: pointer"></i>
                        </a> 
                    </td>   
                </tr>
                @endforeach
            </tbody>
        </table> 
        {!! $ciudades->links() !!}
    </div>
</div>
@endsection