@extends('layout.main')
@section('contenido')
    @if(Session::has('mensaje'))
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong>{{Session::get('mensaje')}}
        </div>
    @endif
    <div class="card mb-2 mt-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Compras</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="{{$texto}}">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="{{url('/compra/create')}}" class="btn btn-primary btn" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm">
                <thead class="table-primary">
                    <tr>
                        <th><div align="center">ID</div></th>
                        <th>Fecha</th>
                        <th>Condicion</th>
                        <th>Proveedor</th>
                        <th>Fact. Nº</th>
                        <th>Entrega</th>
                        <th>Total</th>
                        <th>Estado</th>
                        <th><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    @foreach($compras as $compra)
                        <tr>
                            <td width=10% align="center">{{$compra->idcompra}}</td>
                            <td>{{ date('d/m/Y', strtotime($compra->fecha)) }}</td>
                            <td>{{$compra->condicion}}</td>
                            <td>{{$compra->denominacion}}</td>
                            <td>{{$compra->fact_nro}}</td>
                            <td>{{$compra->entrega}}</td>
                            <td>{{$compra->total}}</td>
                            <td>{{$compra->estado}}</td>
                            <td width=15% align="center"> 
                                <a href="{{url('/compra/'.$compra->idcompra.'/edit')}}" class="btn btn-warning btn-sm" title="Editar">
                                    <i class="bi bi-pencil-fill" style="cursor: pointer"></i>
                                </a> 
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table> 
            {!! $compras->links() !!}
        </div>
    </div>
@endsection