@extends('layout.main')
@section('contenido')
    <div class="card mb-2 mt-2">
        @if (Session::has('mensaje'))
            <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <strong>Atención. </strong>{{ Session::get('mensaje') }}
            </div>
        @endif
        <form action="{{ url('/empresa') }}" method="post">
            @csrf
            <div class="card">
                <div class="card-header">
                    <h4>Registrar una nueva Empresa</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-2 mt-2 ">
                            <label><b>Nombre</b></label>
                            <input type="text" class="form-control form-control-sm" name="nombre" value="{{isset($empresa->nombre)?$empresa->nombre:''}}" id="nombre" autocomplete="off" required>
                        </div>          
                        <div class="col-md-2 mb-2 mt-2">
                            <label><b>Ruc</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->ruc)?$empresa->ruc:''}}" name="ruc" id="ruc" autocomplete="off" required>
                        </div>          
                        <div class="col-md-4 mb-2 mt-2">
                            <label><b>Dirección</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->direccion)?$empresa->direccion:''}}" name="direccion" id="direccion" autocomplete="off" required>
                        </div>          
                        <div class="col-md-2 mb-2 mt-2">
                            <label><b>Teléfono</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->telefono)?$empresa->telefono:''}}" name="telefono" id="telefono" autocomplete="off" required>
                        </div>          
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-2 mt-2">
                            <label><b>Representante Legal</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->representante_legal)?$empresa->representante_legal:''}}" name="representante_legal" id="representante_legal" autocomplete="off" required>
                        </div>
                        <div class="col-md-2 mb-2 mt-2">
                            <label><b>Ruc Representante</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->representante_ruc)?$empresa->representante_ruc:''}}" name="representante_ruc" id="representante_ruc" autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-3">
                            <label><b>Contador</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->contador)?$empresa->contador:''}}" name="contador" id="contador" autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label><b>Ruc Contador</b></label>
                            <input type="text" class="form-control form-control-sm" value="{{isset($empresa->contador_ruc)?$empresa->contador_ruc:''}}" name="contador_ruc" id="contador_ruc" autocomplete="off" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-2">
                            <label><b>Periodo Inicial</b></label>
                            <input type="date" class="form-control" value="{{isset($empresa->periodo_inicial)?$empresa->periodo_inicial:''}}" name="periodo_inicial" id="periodo_inicial" autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label><b>Periodo Final</b></label>
                            <input type="date" class="form-control" value="{{isset($empresa->periodo_final)?$empresa->periodo_final:''}}" name="periodo_final" id="periodo_final" autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label><b>Periodo actual</b></label>
                            <input type="date" class="form-control form-control-sm" value="{{isset($empresa->periodo_actual)?$empresa->periodo_actual:''}}" name="periodo_actual" id="periodo_actual" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="card-footer" align="right">
                    <a href="{{url('/empresa')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
                </div>
            </div>
        </form>
    </div>
@endsection
