@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if (count($errors) > 0)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{ Session::get('mensaje') }}
        </div>
    @endif
    <div class="card mb-2 mt-2">
        <form action="{{ url('/empresa/' . $empresa->idempresa) }}" method="post">
            @csrf
            {{ method_field('PATCH') }}
            <div class="card-header">
                <h4>Editar empresa</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-2 mt-2">
                        <label><b>Nombre</b></label>
                        <input type="text" class="form-control form-control-sm" name="nombre" value="{{ isset($empresa->nombre) ? $empresa->nombre : '' }}" id="nombre" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Ruc</b></label>
                        <input type="text" class="form-control form-control-sm" value="{{ isset($empresa->ruc) ? $empresa->ruc : '' }}" name="ruc" id="ruc" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2 ">
                        <label><b>Dirección</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->direccion) ? $empresa->direccion : '' }}" name="direccion"
                            id="direccion" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Teléfono</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->telefono) ? $empresa->telefono : '' }}" name="telefono" id="telefono"
                            autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-2 mt-2">
                        <label><b>Representante Legal</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->representante_legal) ? $empresa->representante_legal : '' }}"
                            name="representante_legal" id="representante_legal" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label><b>Ruc Representante</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->representante_ruc) ? $empresa->representante_ruc : '' }}"
                            name="representante_ruc" id="representante_ruc" autocomplete="off">
                    </div>
                    <div class="col-md-3 mb-2 mt-2">
                        <label><b>Contador</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->contador) ? $empresa->contador : '' }}" name="contador"
                            id="contador" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label><b>Ruc Contador</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($empresa->contador_ruc) ? $empresa->contador_ruc : '' }}" name="contador_ruc"
                            id="contador_ruc" autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Periodo Inicial</b></label>
                        <input type="date" class="form-control form-control-sm"
                            value="{{ isset($empresa->periodo_inicial) ? $empresa->periodo_inicial : '' }}"
                            name="periodo_inicial" id="periodo_inicial" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Periodo Final</b></label>
                        <input type="date" class="form-control form-control-sm"
                            value="{{ isset($empresa->periodo_final) ? $empresa->periodo_final : '' }}"
                            name="periodo_final" id="periodo_final" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Periodo actual</b></label>
                        <input type="date" class="form-control form-control-sm"
                            value="{{ isset($empresa->periodo_inicial) ? $empresa->periodo_inicial : '' }}"
                            name="periodo_inicial" id="periodo_inicial" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label><b>Estado</b></label>
                        <select name="estado" class="form-select form-select-sm" autocomplete="off" required>
                            <option value="ACTIVO" <?php if ($empresa->estado == 'ACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Activo</option>
                            <option value="INACTIVO" <?php if ($empresa->estado == 'INACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Inactivo</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="{{url('/empresa')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
@endsection
