@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if (count($errors) > 0)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{ Session::get('mensaje') }}
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{url('/proveedor')}}" method="post">
            @csrf    
            <div class="card-header">
                <h4>Registrar un nuevo Proveedor</h4>
            </div>
            <div class="card-body">
                <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">   
                <div class="row">
                    <div class="col-md-3">
                        <label><b>Denominación</b></label>
                        <input type="text" class="form-control form-control-sm" name="denominacion"
                            value="{{ isset($proveedor->denominacion) ? $proveedor->denominacion : '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-2">
                        <label><b>Ruc</b></label>
                        <input type="text" class="form-control form-control-sm" name="ruc"
                            value="{{ isset($proveedor->ruc) ? $proveedor->ruc : '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-4">
                        <label><b>Dirección</b></label>
                        <input type="text" class="form-control form-control-sm" name="direccion"
                            value="{{ isset($proveedor->direccion) ? $proveedor->direccion: '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-2">
                        <label><b>Teléfono</b></label>
                        <input type="text" class="form-control form-control-sm" name="telefono"
                            value="{{ isset($proveedor->telefono) ? $proveedor->telefono : '' }}" autocomplete="off">
                    </div>
                </div>
                <label for="" class="mt-3"><b>Cuenta</b></label>
                <div class="input-group">
                    <select id="idcuenta" name="idcuenta" class="form-select form-control-sm" style="width: 350px">
                        @foreach ($cuentas as $cuenta)
                            <option value="{{ $cuenta['idcuenta'] }}">
                                {{ $cuenta['nombre'] }}</option>
                        @endforeach
                    </select>
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                        data-bs-target="#ModalNuevoBeneficiario">
                        +
                    </button>
                </div>
                <script>
                    $(document).ready(function() {
                        $('#idcuenta').select2();
                    });
                </script>
            </div>
            <div class="card-footer" align="right">
                <a href="{{url('/proveedor')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
@endsection
