@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if (count($errors) > 0)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{ Session::get('mensaje') }}
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{url('/proveedor/'.$proveedor->idproveedor)}}" method="post">
            @csrf    
            {{method_field('PATCH')}}
            <div class="card-header">
                <h4>Editar Proveedor</h4>
            </div>
            <div class="card-body">
                <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">   
                <div class="row">
                    <div class="col-md-3 mb-2 mt-2">
                        <label><b>Denominación</b></label>
                        <input type="text" class="form-control form-control-sm" name="denominacion"
                            value="{{ isset($proveedor->denominacion) ? $proveedor->denominacion : '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label><b>Ruc</b></label>
                        <input type="text" class="form-control form-control-sm" name="ruc"
                            value="{{ isset($proveedor->ruc) ? $proveedor->ruc : '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2">
                        <label><b>Dirección</b></label>
                        <input type="text" class="form-control form-control-sm" name="direccion"
                            value="{{ isset($proveedor->direccion) ? $proveedor->direccion: '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label><b>Teléfono</b></label>
                        <input type="text" class="form-control form-control-sm" name="telefono"
                            value="{{ isset($proveedor->telefono) ? $proveedor->telefono : '' }}" autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-2 mt-2">
                        <label><b>Cuenta</b></label>
                        <div class="input-group">
                            <select name="idcuenta" id="idcuenta" class="form-select form-select-sm" style="width: 350px">
                                @foreach ($cuentas as $cuenta)
                                    @if ($proveedor->idcuenta == $cuenta->idcuenta)
                                        <option value="{{ $cuenta->idcuenta }}" selected>{{ $cuenta->nombre }}
                                    @else
                                        <option value="{{ $cuenta->idcuenta }}">{{ $cuenta->nombre }}
                                    @endif
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#ModalNuevaCuenta">
                                +
                            </button>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $('#idcuenta').select2();
                            });
                        </script>
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label><b>Estado</b></label>
                        <select name="estado" class="form-select form-select-sm" autocomplete="off" required>
                            <option value="ACTIVO" <?php if ($proveedor->estado == 'ACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Activo</option>
                            <option value="INACTIVO" <?php if ($proveedor->estado == 'INACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Inactivo</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="{{url('/proveedor')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
@endsection
