@extends('layout.main')
@section('contenido')
    @if(Session::has('mensaje'))
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>{{Session::get('mensaje')}}</strong>
        </div>
    @endif
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">                
                <h4>Lista de Roles</h4>
                <form class="d-flex" role="search">
                    <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar">
                    <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="{{url('/rol/create')}}" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                </form>               
            </div>
        </div>
        <div class="card-body">
            <table class="table table-sm table-condensed table-striped">
                <thead class="table-primary">
                    <th><div align="center">ID</div></th>
                    <th>Nombre Rol</th>
                    <th>Estado</th>
                    <th><div align="center">Acciones</div></th>
                </thead>
                <tbody>
                    @foreach($rol as $roles)
                        <tr>
                            <td width=10% align="center">{{$roles->idrol}}</td>
                            <td>{{$roles->nombrerol}}</td>
                            <td width="10%">{{$roles->estado}}</td>
                            <td width=15% align="center"> 
                                <a href="{{url('/rol/'.$roles->idrol.'/edit')}}" class="btn btn-warning btn-sm">
                                    <i class="bi bi-pencil-fill" title="Editar" style="cursor: pointer"></i>
                                </a> 
                                <a href="{{url('/rol/permisos/'.$roles->idrol)}}" class="btn btn-warning btn-sm" title="Permisos" style="cursor: pointer">
                                    <i class="bi bi-lock-fill"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table> 
            {!! $rol->links() !!}
        </div>
    </div>
@endsection