@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if(count($errors)>0)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{$error}}</li>             
            @endforeach
        </ul>
    </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{ Session::get('mensaje') }}
        </div>
    @endif
    <div class="card mb-2 mt-2">
        <form action="{{ url('/sucursal') }}" method="post">
            @csrf
            <div class="card">
                <div class="card-header">
                    <h4>Registrar una Sucursal</h4>
                </div>
                <div class="card-body">
                    <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">   
                    <div class="row mb-2 mt-2">
                        <div class="col-md-3">
                            <label><b>Nombre</b></label>
                            <input type="text" class="form-control form-control-sm" name="nombre" id="nombre" autocomplete="off">
                        </div>          
                        <div class="col-md-4">
                            <label><b>Dirección</b></label>
                            <input type="text" name="direccion" class="form-control form-control-sm">
                        </div>
                        <div class="col-md-3">
                            <label for="" class="text-dark"><b>Ciudad</b></label>
                            <div class="input-group">
                                <select id="idciudad" name="idciudad" class="form-select form-control-sm" style="width: 270px">
                                    @foreach ($ciudades as $ciudad)
                                        <option value="{{ $ciudad['idciudad'] }}">{{ $ciudad['nombre'] }}</option>
                                    @endforeach
                                </select>
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                    data-bs-target="#ModalNuevoBeneficiario">
                                    +
                                </button>
                            </div>
                            <script>
                                $(document).ready(function() {
                                    $('#idciudad').select2();
                                });
                            </script>
                        </div>
                        <div class="col-md-2">
                            <label><b>Teléfono</b></label>
                            <input type="text" name="telefono" class="form-control form-control-sm">
                        </div>
                    </div>
                </div>
                <div class="card-footer" align="right">
                    <a href="{{url('/sucursal')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
                </div>
            </div>
        </form>
    </div>
@endsection
