<div class="card-body">
    <div class="row">
        <fieldset disabled>
            <div class="form-group row">
                <div class="col-sm-4">
                    <div class="form-floating">
                        <input type="text" class="form-control form-control-sm" readonly value="{{ $usuario->nick }} ">
                        <label for="floatingInput">Usuario</label>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-floating">
                        <input type="text" class="form-control form-control-sm" readonly
                            value="{{ $usuario->nombre }} ">
                        <label for="floatingInput">Nombre</label>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-floating">
                        @if ($usuario->activo == 1)
                            <input type="text" class="form-control form-control-sm" readonly
                            value="ACTIVO">
                        @else
                            <input type="text" class="form-control form-control-sm" readonly
                            value="INACTIVO">
                        @endif
                        <label for="floatingInput">Estado</label>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>
    <p class="login-box-msg"></p>
    <div class="row">
        <div class="col-sm-4">
            <div class="input-group input-group-sm">
                <span class="input-group-text" id="inputGroup-sizing-sm">Roles Disponibles:</span>
                <select name="idrol" id="idrol" class="form-control-sm js-example-basic-single"
                aria-label="Sizing example input" aria-describedby="inputGroup-sizing-sm">
                    @foreach ($roldisponible as $roles)
                        <option value="{{ $roles->idrol }}">{{ $roles->nombrerol }} </option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-sm-2">
            <button type="button" class="btn btn-primary btn3 btn-sx" id='boton-guardar'
                role='button'>
                {{-- <i class="fas fa-angle-double-right"></i> --}}
                <i class="bi bi-skip-forward-fill"></i>
            </button>
        </div>
        <div class="col-sm-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title">Roles actuales del usuario</h6>
                </div>
                <div class="form-group col-sm-12">
                    <div class="table-responsive">
                        <table class="table table-striped table-sm" id="perfil">
                            <thead>
                                <tr>
                                    <th width="1%">ID</th>
                                    <th>Rol</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody id="tbody">
                                    @foreach ($perfilactual as $key => $actual)
                                        <tr>
                                            <td width="1%">
                                                {!! Form::number('idrol', $actual->idrol, ['class'=>"form-control form-control-sm",'readonly' ,'name' => 'perfiles[' . $key . '][idrol]']) !!}
                                            </td>
                                            <td width="5%">
                                                {!! $actual->nombrerol!!}
                                            </td>
                                            <td width="5%">
                                                @php
                                                 echo'<select class="form-control form-control-sm" id="perfilestado" name="perfiles['. $key . '][perfilestado]">'
                                                @endphp
                                                @if ($actual->perfilestado == 'ACTIVO')
                                                    <option value="ACTIVO" selected>ACTIVO</option>
                                                    <option value="INACTIVO">INACTIVO</option>
                                                @else
                                                    <option value="ACTIVO">ACTIVO</option>
                                                    <option value="INACTIVO" selected>INACTIVO</option>
                                                @endif
                                            </td>
                                        </tr>  
                                    @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card-footer" align="right">
    {!! Form::hidden('guardaperfiles',1) !!}
    {!! Form::hidden('idusuario', $usuario->idusuario) !!}
    <a href="{{ URL::previous() }}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
</div>

@push('scripts')
    <script type="text/javascript">
        var contador = 1
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            
            $("#boton-guardar").click(function() {
                // var contador = $('.item-table tbody tr').length;
                // alert(contador);
                var idrol = $('#idrol').val();
                var rolnombre = $("#idrol option:selected").text();
                $("#perfil").find('tbody')
                    .append($('<tr>')
                        .append($('<td width="1%">' + '<input type="number" readonly value="' + idrol + '"name=perfiles[' + contador +'][idrol]"</td>'))
                        .append($('<td width="5%">' + '<input type="text" readonly value="' + rolnombre + '"class="form-control form-control-sm" name="perfiles[' +
                            contador + '][nombrerol]"</td>'))
                        .append($('<td width="5%">' + '<select id="perfilestado" name="perfiles[' + contador +
                            '][perfilestado]" class="form-control form-control-sm"><option value="ACTIVO">ACTIVO</option><option value="INACTIVO">INACTIVO</option></select>' +
                            '</td>'))
                        .append($('</tr>'))
                    );
                contador++
            });

        });
    </script>
@endpush
