<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong><?php echo e(Session::get('mensaje')); ?></strong>
        </div>
    <?php endif; ?>
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Asiento</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search"
                            placeholder="Buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit">Buscar</button>
                        <a href="<?php echo e(url('/asiento/create')); ?>" class="btn btn-primary btn">Nuevo</a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-sm table-condensed table-striped">
                <thead>
                    <tr class="table-primary">
                        <th>
                            <div align="center">ID</div>
                        </th>
                        <th>Empresa</th>
                        <th>Sucursal</th>
                        <th>Fecha</th>
                        <th>Nº Asiento</th>
                        <th>
                            <div align="center">Acciones</div>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $asientos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asiento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td width=10% align="center"><?php echo e($asiento->idasiento); ?></td>
                            <td><?php echo e($asiento->nro_asiento); ?></td>
                            <td><?php echo e(date('d/m/Y', strtotime($asiento->fecha_asiento))); ?></td>
                            <td>
                                <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($asiento->idempresa == $empresa->idempresa): ?>
                                        <?php echo e($empresa->nombre); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td>
                                <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($asiento->idsucursal == $sucursal->idsucursal): ?>
                                        <?php echo e($sucursal->nombre); ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td width=8% align="center">
                                <?php
                                    echo '<a href="asiento/'.$asiento->idasiento.'" class="btn btn-success btn-sm"><i class="fas fa-info"></i></a>';
                                ?>
                                <a href="<?php echo e(url('/asiento/' . $asiento->idasiento . '/edit')); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-pen fa-lg" title="Editar" style="cursor: pointer"></i>
                                </a>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo $asientos->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/asiento/index.blade.php ENDPATH**/ ?>