<?php $__env->startSection('contenido'); ?>
    <div class="card mb-2 mt-2">
        <?php if(Session::has('mensaje')): ?>
            <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <strong><?php echo e(Session::get('mensaje')); ?></strong>
            </div>
        <?php endif; ?>
        <div class="card">
            <div class="card-header">
                <h4>Detalles de la Cuenta</h4>
            </div>
            <div class="card-body">
                <table class="table table-condensed table-bordered">
                    <tr>
                        <td class="table-primary col-md-2"><b>Id</b></td>
                        <td><?php echo e($cuenta->idcuenta); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Nombre</b></td>
                        <td><?php echo e($cuenta->nombre); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Empresa</b></td>
                        <td>
                            <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($cuenta->idempresa == $empresa->idempresa): ?>
                                    <?php echo e($empresa->nombre); ?>

                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Código</b></td>
                        <td><?php echo e($cuenta->codigo); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Tipo Saldo</b></td>
                        <td><?php echo e($cuenta->tipo_saldo); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Imputable</b></td>
                        <td><?php echo e($cuenta->imputable); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Tipo Actividad</b></td>
                        <td><?php echo e($cuenta->tipo_actividad); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Clasificación</b></td>
                        <td><?php echo e($cuenta->clasificacion); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Presupuestable</b></td>
                        <td><?php echo e($cuenta->presupuestable); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Nivel</b></td>
                        <td><?php echo e($cuenta->clasificacion); ?></td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Fecha Creación</b></td>
                        <td><?php echo e(date('d/m/Y', strtotime($cuenta->fecha_creacion))); ?></td>
                        
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Usuario Creación</b></td>
                        <td>
                            <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($cuenta->usuario_creacion == $usuario->idusuario): ?>
                                    <?php echo e($usuario->nombre); ?>

                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Estado</b></td>
                        <td>
                            <?php if($cuenta->activo == 1): ?>
                                ACTIVO
                            <?php else: ?>
                                INACTIVO
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="card-footer" align="right">
                <a href="<?php echo e(url('/cuenta')); ?>" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-arrow-left-circle-fill"></i> Volver</a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/cuenta/detalle.blade.php ENDPATH**/ ?>