<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(env('APP_NAME')); ?> | Log in</title>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(url('/assets/plugins/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(url('/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(url('/iconos/bootstrap-icons.min.css')); ?>">
    
    <script src="<?php echo e(asset('/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/jquery-3.6.0.min.js')); ?>"></script>
    
</head>

<body class="hold-transition login-page">
    <br>
    <div class="container">
        <div class="login-box">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header text-center bg-dark text-white">Seleccione la Empresa a Operar</div>
                        <div class="card-body">
                            <?php if(Session::has('mensaje')): ?>
                                <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                    <strong><?php echo e(Session::get('mensaje')); ?></strong>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo e(url('/loginempresa')); ?>" method="post">
                                
                                <?php if(Auth::user()): ?>
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" value="<?php echo e($datoslogin['idusuario']); ?>" name="idusuario">
                                    <div class="row mb-3">
                                        <label for="email" class="col-md-4 col-form-label text-md-end"><b><?php echo e(__('Usuario')); ?></b></label>
                                        <div class="col-md-6">
                                            <input type="text" readonly class="form-control" name="nombre"
                                                value="<?php echo e($datoslogin['nombre']); ?>">
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label for="password" class="col-md-4 col-form-label text-md-end"><b><?php echo e(__('Contraseña')); ?></b></label>
                                        <div class="col-md-6">
                                            <input type="password" readonly class="form-control" name="contrasena"
                                                value="<?php echo e($datoslogin['contrasena']); ?>">
                                        </div>
                                    </div>
                                    
                                    <div class="row mb-3">
                                        
                                        <label for="email" class="col-md-4 col-form-label text-md-end"><b><?php echo e(__('Empresa')); ?></b></label>
                                        <div class="col-md-6">
                                            <select class="form-select" id="idempresa" name="idempresa"
                                                class="form-control">
                                                <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($empresa['idempresa']); ?>"><?php echo e($empresa['nombre']); ?>

                                                </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <script>
                                            $(document).ready(function() {
                                                $('#idempresa').select2();
                                            });
                                        </script>
                                    </div>
                                    <div class="row mb-0">
                                        <div class="col-md-8 offset-md-4">
                                            
                                            <a class="btn btn-secondary" href="<?php echo e(route('logout')); ?>"><i class="bi bi-x-circle"></i> <b>Cancelar</b></a>
                                            
                                            <button type="submit" class="btn btn-primary"><i class="bi bi-check2-circle bi-lg"></i> 
                                                <b><?php echo e(__('Seleccionar')); ?></b>
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/auth/login_empresa.blade.php ENDPATH**/ ?>