<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2 mt-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Compras</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="<?php echo e(url('/compra/create')); ?>" class="btn btn-primary btn" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm">
                <thead class="table-primary">
                    <tr>
                        <th><div align="center">ID</div></th>
                        <th>Fecha</th>
                        <th>Condicion</th>
                        <th>Proveedor</th>
                        <th>Fact. Nº</th>
                        <th>Entrega</th>
                        <th>Total</th>
                        <th>Estado</th>
                        <th><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    <?php $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td width=10% align="center"><?php echo e($compra->idcompra); ?></td>
                            <td><?php echo e(date('d/m/Y', strtotime($compra->fecha))); ?></td>
                            <td><?php echo e($compra->condicion); ?></td>
                            <td><?php echo e($compra->denominacion); ?></td>
                            <td><?php echo e($compra->fact_nro); ?></td>
                            <td><?php echo e($compra->entrega); ?></td>
                            <td><?php echo e($compra->total); ?></td>
                            <td><?php echo e($compra->estado); ?></td>
                            <td width=15% align="center"> 
                                <a href="<?php echo e(url('/compra/'.$compra->idcompra.'/edit')); ?>" class="btn btn-warning btn-sm" title="Editar">
                                    <i class="bi bi-pencil-fill" style="cursor: pointer"></i>
                                </a> 
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table> 
            <?php echo $compras->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/compra/index.blade.php ENDPATH**/ ?>