<?php $__env->startSection('contenido'); ?>
    
    <?php if(count($errors) > 0): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2">
        <form action="<?php echo e(url('/cliente/'.$cliente->idcliente)); ?>" method="post">
            <?php echo csrf_field(); ?>    
            <?php echo e(method_field('PATCH')); ?>

            <div class="card-header">
                <h4>Editar Cliente</h4>
            </div>
            <div class="card-body">
                
                <div class="row">
                    <div class="col-md-2 mb-2 mt-2">
                        <label for="floatingInput"><b>Ruc</b></label>
                        <input type="text" class="form-control" name="ruc"
                            value="<?php echo e(isset($cliente->ruc) ? $cliente->ruc : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2">
                        <label for="floatingInput"><b>Denominación</b></label>
                        <input type="text" class="form-control" name="denominacion"
                            value="<?php echo e(isset($cliente->denominacion) ? $cliente->denominacion : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2">
                        <label for="floatingInput"><b>Dirección</b></label>
                        <input type="text" class="form-control" name="direccion"
                            value="<?php echo e(isset($cliente->direccion) ? $cliente->direccion : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label for="floatingInput"><b>Teléfono</b></label>
                        <input type="text" class="form-control" name="telefono"
                            value="<?php echo e(isset($cliente->telefono) ? $cliente->telefono : ''); ?>" autocomplete="off">
                    </div>
                </div>
                <div class="col-md-2 mb-2 mt-2">
                    <label for="estado"><b>Estado</b></label>
                    <select name="estado" class="form-select form-select-sm" autocomplete="off" required>
                        <?php if($cliente->estado == 'ACTIVO' ): ?>
                            <option value="ACTIVO" selected>ACTIVO</option>
                            <option value="INACTIVO">INACTIVO</option>
                        <?php else: ?>
                            <option value="ACTIVO">ACTIVO</option>
                            <option value="INACTIVO" selected>INACTIVO</option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="<?php echo e(url('/cliente')); ?>" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/cliente/edit.blade.php ENDPATH**/ ?>