<?php $__env->startSection('contenido'); ?>
    
    <?php if(count($errors) > 0): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2 mt-2">
        <form action="<?php echo e(url('/empresa/' . $empresa->idempresa)); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo e(method_field('PATCH')); ?>

            <div class="card-header">
                <h4>Editar empresa</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="mb-2 mt-2 col-md-4">
                        <label for="floatingInput">Nombre</label>
                        <input type="text" class="form-control form-control-sm" name="nombre" value="<?php echo e(isset($empresa->nombre) ? $empresa->nombre : ''); ?>" id="nombre" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Ruc</label>
                        <input type="text" class="form-control form-control-sm" value="<?php echo e(isset($empresa->ruc) ? $empresa->ruc : ''); ?>" name="ruc" id="ruc" autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="mb-2 mt-2 col-md-3">
                        <label for="floatingInput">Dirección</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->direccion) ? $empresa->direccion : ''); ?>" name="direccion"
                            id="direccion" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Teléfono</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->telefono) ? $empresa->telefono : ''); ?>" name="telefono" id="telefono"
                            autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="mb-2 mt-2 col-md-4">
                        <label for="floatingInput">Representante Legal</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->representante_legal) ? $empresa->representante_legal : ''); ?>"
                            name="representante_legal" id="representante_legal" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-3">
                        <label for="floatingInput">Ruc Representante</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->representante_ruc) ? $empresa->representante_ruc : ''); ?>"
                            name="representante_ruc" id="representante_ruc" autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="mb-2 mt-2 col-md-4">
                        <label for="floatingInput">Contador</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->contador) ? $empresa->contador : ''); ?>" name="contador"
                            id="contador" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-3">
                        <label for="floatingInput">Ruc Contador</label>
                        <input type="text" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->contador_ruc) ? $empresa->contador_ruc : ''); ?>" name="contador_ruc"
                            id="contador_ruc" autocomplete="off">
                    </div>
                </div>
                <div class="row">
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Periodo Inicial</label>
                        <input type="date" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->periodo_inicial) ? $empresa->periodo_inicial : ''); ?>"
                            name="periodo_inicial" id="periodo_inicial" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Periodo Final</label>
                        <input type="date" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->periodo_final) ? $empresa->periodo_final : ''); ?>"
                            name="periodo_final" id="periodo_final" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Periodo actual</label>
                        <input type="date" class="form-control form-control-sm"
                            value="<?php echo e(isset($empresa->periodo_inicial) ? $empresa->periodo_inicial : ''); ?>"
                            name="periodo_inicial" id="periodo_inicial" autocomplete="off">
                    </div>
                    <div class="mb-2 mt-2 col-md-2">
                        <label for="floatingInput">Estado</label>
                        <select name="estado" class="form-control required" autocomplete="off" required>
                            <option value="ACTIVO" <?php if ($empresa->estado == 'ACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Activo</option>
                            <option value="INACTIVO" <?php if ($empresa->estado == 'INACTIVO') {
                                echo 'selected="selected" ';
                            } ?>>Inactivo</option>
                        </select>
                    </div>
                    
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="<?php echo e(url('/empresa')); ?>" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/empresa/edit.blade.php ENDPATH**/ ?>